/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWColorListCellRenderer
extends JLabel
implements ListCellRenderer {
    public static final Color COLOR_BLUE = new Color(162, 222, 249);
    public static final Color COLOR_GRAY = new Color(212, 213, 214);
    public static final Color COLOR_GREEN = new Color(217, 226, 90);
    public static final Color COLOR_PINK = new Color(247, 187, 213);
    public static final Color COLOR_YELLOW = new Color(255, 214, 80);
    private static final Icon m_blueIcon = VWImageLoader.createImageIcon("text_annotation_blue.gif");
    private static final Icon m_grayIcon = VWImageLoader.createImageIcon("text_annotation_gray.gif");
    private static final Icon m_greenIcon = VWImageLoader.createImageIcon("text_annotation_green.gif");
    private static final Icon m_pinkIcon = VWImageLoader.createImageIcon("text_annotation_pink.gif");
    private static final Icon m_yellowIcon = VWImageLoader.createImageIcon("text_annotation_yellow.gif");
    private static final Icon m_blankIcon = VWImageLoader.createImageIcon("blank.gif");

    public VWColorListCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list != null && value != null) {
            JLabel colorLabel;
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Color && (colorLabel = VWColorListCellRenderer.getLabel((Color)value)) != null) {
                this.setText(colorLabel.getText());
                this.setIcon(colorLabel.getIcon());
            }
        } else {
            this.setText("");
            this.setIcon(null);
        }
        return this;
    }

    public static JLabel getLabel(Color color) {
        JLabel colorLabel = null;
        if (color != null) {
            colorLabel = color.equals(COLOR_BLUE) ? new JLabel(VWResource.s_blue, m_blueIcon, 10) : (color.equals(COLOR_GRAY) ? new JLabel(VWResource.s_gray, m_grayIcon, 10) : (color.equals(COLOR_GREEN) ? new JLabel(VWResource.s_green, m_greenIcon, 10) : (color.equals(COLOR_PINK) ? new JLabel(VWResource.s_pink, m_pinkIcon, 10) : (color.equals(COLOR_YELLOW) ? new JLabel(VWResource.s_yellow, m_yellowIcon, 10) : new JLabel(VWResource.s_other, m_blankIcon, 10)))));
        }
        return colorLabel;
    }

    public static Color[] getAvailableColors() {
        return new Color[]{COLOR_BLUE, COLOR_GRAY, COLOR_GREEN, COLOR_PINK, COLOR_YELLOW};
    }
}

